#include <iostream>
#include <vector>
#include <set>

int N, Q;
std::vector<int> a;   
std::vector<int> pos;

int prekidi=0;
bool postoji_prekid(int x) {
    if (x<1 || x>=N) return false;
    return pos[x]>pos[x+1];
}
void azuriraj_prekide(int x, int y) {
    std::set<int> s;
    for (int d=-1; d<=1; ++d) {
        int a1=a[x]+d;
        int a2=a[y]+d;
        if (1<=a1 && a1<N) s.insert(a1);
        if (1<=a2 && a2<N) s.insert(a2);
    }
    for (int v : s) prekidi-=postoji_prekid(v);

    std::swap(pos[a[x]], pos[a[y]]);
    std::swap(a[x], a[y]);

    for (int v : s) prekidi+=postoji_prekid(v);
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(0), std::cout.tie(0);

    std::cin>>N>>Q;
    a.resize(N);
    pos.resize(N+2); 

    for (int i=0; i<N; ++i) {
        std::cin>>a[i];
        pos[a[i]]=i;
    }

    for (int i=1; i<N; ++i) {
        if (pos[i]>pos[i+1]) ++prekidi;
    }

    std::cout<<prekidi<<std::endl;
    while(Q--) {
        int i, j;
        std::cin>>i>>j;
        --i; --j;
        azuriraj_prekide(i, j);
        std::cout<<prekidi<<std::endl;
    }

    return 0;
}